dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 240, 300, "assets/images/table/cruise_6", "assets/images/food/item_mark3", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 1;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1

guest = LManager.GenGuest(female02);
guest.matchType = female03;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 5, 20000);

-- Group 3

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
guest.percentRequestCoffee = 70;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 6, 26000);

-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = male04;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 7, 40000);


-- Group 5

guest = LManager.GenGuest(female04);
guest.matchType = female03;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 8, 53000);


-- Group 5

guest = LManager.GenGuest(male01);
guest.matchType = female03;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 12, 72000);

-- Group 6

guest = LManager.GenGuest(male01);
guest.matchType = female03;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 13, 88000);

-- Group 7

guest = LManager.GenGuest(female02);
guest.matchType = NOT_GUEST + female01;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
guest.tolerance = 20000;
guest.waitBeforeDinner = 2000;
guest.waitBeforeCake = 2000;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(14, 15, 110000);


LManager:AdjustGuestTolerance(130);


LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 75000 );


LManager:SetLevelSetting ("speakerDelay", 110000); 
LManager:SetLevelSetting ("speakerChance", 100);


-- Set up the Level Settings
LManager:SetLevelNumber(3,2);
LManager:SetLevelScores(4400, 6800);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_1.ogg", "assets/audio/music/Dance Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );